/*
*   control:
*     000  alu
*     001  compare
*     010  shift
*     011  shift-immediate
*     100  load data
*     101  store data
*     110  nextpc
*     111  jmp, ret, callr
*/

module muxc(oal,obs,cmp,nextpc,data,control,out);
input [31:0] oal,obs,data;
input [7:0] nextpc;
input cmp;
input [2:0] control;
output [31:0] out;
reg [31:0] out;
wire [31:0] next;
// calculate pc for full address space
assign next = {22'h000000,nextpc,2'b00};

always
	case(control)
	3'b000: out <= oal;
	3'b001:	out <= {31'h00000000,cmp};
	3'b010: out <= obs;
	3'b011: out <= obs;
	3'b100: out <= data;
	3'b101: out <= data;
	default: out <= next;
	endcase
endmodule