module iformat(op,control,muxc,branch);
input [5:0] op;
output [5:0] control;
output [1:0] muxc;
output branch;

reg [5:0] control;
reg [1:0] muxc;

always
	case (op)
	6'h00: // call
	begin
		control <= 6'h30;
		muxc <= 2'b00;
	end
	6'h04: 
	begin
		control <= 6'h00; // addi
		muxc <= 2'b01; // se 
	end
	6'h06: // br
	begin
		control <= 6'h08;
		muxc <= 2'b00;
	end
	6'h08:
	begin
		control <= 6'h0b; // cmpgei
		muxc <= 2'b01;
	end
	6'h0c: 
	begin
		control <= 6'h04; // andi
		muxc <= 2'b10;
	end
	6'h0e: // bge
	begin
		control <= 6'h0b;
		muxc <= 2'b00;
	end
	6'h10:
	begin
		control <= 6'h0a; // cmplti
		muxc <= 2'b01;
	end
	6'h14: 
	begin
		control <= 6'h05;  // ori
		muxc <= 2'b10;
	end
	6'h15: 
	begin
		control <= 6'h28; // stw
		muxc <= 2'b01;
	end
	6'h16:
	begin
		control <= 6'h0a;  // blt
		muxc <= 2'b00;
	end
	6'h17:
	begin
		control <= 6'h20; // lwd
		muxc <= 2'b01;
	end
	6'h18:
	begin
		control <= 6'h09; // cmpnei
		muxc <= 2'b01;
	end
	6'h1c: 
	begin 
		control <= 6'h06; // xori
		muxc <= 2'b10;
	end
	6'h1e:
	begin
		control <= 6'h09; // bne
		muxc <= 2'b00;
	end
	6'h20:
	begin
		control <= 6'h08; // cmpeqi
		muxc <= 2'b01;
	end
	6'h26:
	begin
		control <= 6'h08; // beq
		muxc <= 2'b00;
	end
	6'h28:
	begin
		control <= 6'h0f; // cmpgeui
		muxc <= 2'b01;
	end
	6'h2c: 
	begin
		control <= 6'h04; // andhi
		muxc <= 2'b11; // hi
	end
	6'h2e:
	begin
		control <= 6'h0f; // bgeu
		muxc <= 2'b00;
	end
	6'h30:
	begin
		control <= 6'h0e; // cmpltu
		muxc <= 2'b01;
	end
	6'h34: 
	begin
		control <= 6'h05; // orhi
		muxc <= 2'b11; // hi
	end
	6'h36:
	begin
		control <= 6'h0e; // bltu
		muxc <= 2'b00;
	end
	6'h3c:
	begin 
		control <= 6'h06; // xorhi
		muxc <= 2'b11; // hi
	end
	default: 
	begin
		control <= 6'h00;
		muxc <= 2'b00; // nop
	end
	endcase

	assign branch = (control[5:3]==3'b001)&(!muxc[0]);
	
endmodule