/*
*    control[5:3]                control[2:0]
*    000  alu operation          000    add (signed)        sll
*    001  compare                001    subtract (signed)   srl
*    010  shift                  010    add (unsigned)
*    011  shift immediate        011    subtract (unsigned) sra
*                                100    and                 rol
*    control[1:0]		         101    or                  ror
*     00  ==                     110    xor
*     01  !=                     111    nor
*     10  <
*     11  >=
*     control[2]                 control[5:3]
*        0  signed               100 load data
*        1  unsigned             101 nextpc
*                                110   nop,  jr (jmp, ret)
*                                111 nextpc, jr (callr)
*/

module rformat(opx,control);
input [5:0] opx;
output [5:0] control;

reg [5:0] control;

always
	case (opx)
	6'h02: control = 6'h1c; // roli
	6'h03: control = 6'h14; // rol
	6'h05: control = 6'h30; // ret
	6'h06: control = 6'h07; // nor
	6'h08: control = 6'h0b; // cmpge
	6'h0b: control = 6'h15; // ror
	6'h0d: control = 6'h30; // jmp
	6'h0e: control = 6'h04; // and
	6'h10: control = 6'h0a; // cmplt
	6'h12: control = 6'h18; // slli
	6'h13: control = 6'h10; // sll
	6'h16: control = 6'h05; // or
	6'h18: control = 6'h09; // cmpne
	6'h1a: control = 6'h19; // srli
	6'h1b: control = 6'h11; // srl
	6'h1c: control = 6'h28; // nextpc
	6'h1d: control = 6'h38; // callr
	6'h1e: control = 6'h06; // xor
	6'h20: control = 6'h08; // cmpeq
	6'h28: control = 6'h0f; // cmpgeu
	6'h30: control = 6'h0e; // cmpltu
	6'h31: control = 6'h00; // add
	6'h39: control = 6'h01; // sub
	6'h3a: control = 6'h1b; // srai
	6'h3b: control = 6'h13; // sra
	default: control = 6'h00;
	endcase
	
endmodule