module iformat(op,control,muxc);
input [5:0] op;
output [2:0] control;
output [1:0] muxc;

reg [2:0] control;
reg [1:0] muxc;

always
	case (op)
	6'h04: 
	begin
		control <= 3'b000; // addi
		muxc <= 2'b01; // se 
	end
	6'h0c: 
	begin
		control <= 3'b100; // andi
		muxc <= 2'b10;
	end
	6'h14: 
	begin
		control <= 3'b101; // ori
		muxc <= 2'b10;
	end
	6'h1c: 
	begin 
		control <= 3'b110; // xori
		muxc <= 2'b10;
	end
	6'h2c: 
	begin
		control <= 3'b100; // andhi
		muxc <= 2'b11; // hi
	end
	6'h34: 
	begin
		control <= 3'b101; // orhi
		muxc <= 2'b11; // hi
	end
	6'h3c:
	begin 
		control <= 3'b110; // xorhi
		muxc <= 2'b11; // hi
	end
	default: 
	begin
		control <= 3'b000;
		muxc <= 2'b00; // nop
	end
	endcase
	
endmodule