module srisc1(input clock, input reset, output reg [7:0] pc, output [31:0] ir);

wire [31:0] da, db, dc;
wire [4:0] ra, rb, rc;
wire write_enable;

// instantiate memory
inst inst_cache(
	.address(pc),
	.clock(clock),
	.q(ir)
);


always @(posedge clock or negedge reset)
begin
	if (!reset) pc <= 8'h00;
	else pc <= pc + 8'h01;
end

endmodule
