/*
 SW8 (GLOBAL RESET) resets LCD
ENTITY LCD_Display IS
-- Enter number of live Hex hardware data values to display
-- (do not count ASCII character constants)
	GENERIC(Num_Hex_Digits: Integer:= 2); 
-----------------------------------------------------------------------
-- LCD Displays 16 Characters on 2 lines
-- LCD_display string is an ASCII character string entered in hex for 
-- the two lines of the  LCD Display   (See ASCII to hex table below)
-- Edit LCD_Display_String entries above to modify display
-- Enter the ASCII character's 2 hex digit equivalent value
-- (see table below for ASCII hex values)
-- To display character assign ASCII value to LCD_display_string(x)
-- To skip a character use 8'h20" (ASCII space)
-- To dislay "live" hex values from hardware on LCD use the following: 
--   make array element for that character location 8'h0" & 4-bit field from Hex_Display_Data
--   state machine sees 8'h0" in high 4-bits & grabs the next lower 4-bits from Hex_Display_Data input
--   and performs 4-bit binary to ASCII conversion needed to print a hex digit
--   Num_Hex_Digits must be set to the count of hex data characters (ie. "00"s) in the display
--   Connect hardware bits to display to Hex_Display_Data input
-- To display less than 32 characters, terminate string with an entry of 8'hFE"
--  (fewer characters may slightly increase the LCD's data update rate)
------------------------------------------------------------------- 
--                        ASCII HEX TABLE
--  Hex						Low Hex Digit
-- Value  0   1   2   3   4   5   6   7   8   9   A   B   C   D   E   F
------\----------------------------------------------------------------
--H  2 |  SP  !   "   #   $   %   &   '   (   )   *   +   ,   -   .   /
--i  3 |  0   1   2   3   4   5   6   7   8   9   :   ;   <   =   >   ?
--g  4 |  @   A   B   C   D   E   F   G   H   I   J   K   L   M   N   O
--h  5 |  P   Q   R   S   T   U   V   W   X   Y   Z   [   \   ]   ^   _
--   6 |  `   a   b   c   d   e   f   g   h   i   j   k   l   m   n   o
--   7 |  p   q   r   s   t   u   v   w   x   y   z   {   |   }   ~ DEL
-----------------------------------------------------------------------
-- Example "A" is row 4 column 1, so hex value is 8'h41"
-- *see LCD Controller's Datasheet for other graphics characters available
*/
		
module LCD_string(input [4:0] index, output reg [7:0] out, input [7:0] pc, input [31:0] ir);

// ASCII hex values for LCD Display
// Enter Live Hex Data Values from hardware here
// LCD DISPLAYS THE FOLLOWING:
//----------------------------
//| PC xx                    |
//| IR xxxxxxxx              |
//----------------------------
// Line 1
   always 
     case (index)
	5'h00: out <= 8'h50;    // P
	5'h01: out <= 8'h43;    // C
	5'h02: out <= 8'h20;
	5'h03: out <= {4'h0,pc[7:4]};
	5'h04: out <= {4'h0,pc[3:0]};
// Line 2
	5'h10: out <= 8'h49;   // I
	5'h11: out <= 8'h52;   // R
	5'h12: out <= 8'h20;
	5'h13: out <= {4'h0,ir[31:28]};
	5'h14: out <= {4'h0,ir[27:24]};
	5'h15: out <= {4'h0,ir[23:20]};
	5'h16: out <= {4'h0,ir[19:16]};
	5'h17: out <= {4'h0,ir[15:12]};
	5'h18: out <= {4'h0,ir[11:8]};
	5'h19: out <= {4'h0,ir[7:4]};
	5'h1a: out <= {4'h0,ir[3:0]};
	default: out <= 8'h20;
     endcase
endmodule