.include "./nios_macros.m"

.text

.global main
.type main, @function

main:
	movia	r4,table  # load unsigned bytes
	ldbu	r7,0(r4)
	ldbu	r8,1(r4)
	ldbu	r9,2(r4)
	ldbu	r10,3(r4)

high2:	movia   r4,table  # transfer half-words
	ldh	r7,0(r4)
	sth	r7,12(r4)
	ldh	r7,2(r4)
	sth	r7,14(r4)

	ldhu	r7,0(r4)  # transfer unsigned half-words
	sth	r7,8(r4)
	ldhu	r7,2(r4)
	sth	r7,10(r4)

	ldw	r8,8(r4)   # test transfer
	ldw	r8,12(r4)
	
copy:	movia	r4,str    # src string
	addi	r5,r4,80  # dst string
	mov	r6,r5
loop: 	ldb	r7,0(r4)  # copy string elsewhere in memory
	stb	r7,0(r5)
	addi	r4,r4,1
	addi	r5,r5,1
	bne	r7,zero,loop

	ldw	r8,0(r6)  # test transfer
	ldw     r8,4(r6)
	ldw     r8,8(r6)

end:
	br	end   /* wait here once the program has completed */

.data

str:	.asciz "This is a string"
	.balign 4
table:	.word  0x8a0b8c0d, 0x01020304, 0xffffffff,0xaaaaaaaa

.end
