/* timer3.c
 *
 *  Use timer1 to blink an LED
*/

#include <plib.h>

void wait();

#define LED1 BIT_0  // LED1 is connected to RD0


int main()
{
	int i;
	mPORTDSetPinsDigitalOut(LED1);   /* Make LED1 output */
	mPORTDClearBits(LED1);      /* Turn off LED1 on startup */
	while (1) {
		mPORTDToggleBits(LED1);     /* Toggle LED1 */
		wait();
	}
	return 0;
}

void wait()
{
	const int DLY = 36000;
	T1CON = 0x30; // turn timer off and set prescaller to 1:256
	TMR1 = 0;
	PR1 = 0xFFFF;
	T1CONSET = 0x8000; // start timer
	while (TMR1 < DLY) {
		// just wait
	}
	T1CONCLR = 0x8000; // stop timer
}
