# mips1.s illustrates arithmetic (add/subtract) and logical operations

	.global main

	.text

    /* This directive tells the assembler don't optimize
     * the order of the instructions and don't insert
     * 'nop' instructions after jumps and branches.
    */
	.set noreorder

/*********************************************************************
 * main()
 * This is where the PIC32 start-up code will jump to after initial
 * set-up.
 ********************************************************************/

.ent main   # directive that marks symbol 'main' as function in ELF output

main:
	li  $t0, 2008   # macro for "load immediate"
	li  $t1, 18

	add $v0,$t0,$t1    # add and subtract
	sub $v1,$t0,$t1
	neg $t2,$t1        # macro for "negate"
	addu $t3,$t0,$t2   # should be the same as t0 - t1

	li  $t0,0xABCD8421  # 32-bit constant
	la  $t1,main        # macro for "load address" 

	li  $t0, 0x0101  #logic operations
	li  $t1, 0x0011
	and $v0,$t0,$t1
	or  $v0,$t0,$t1
    not $v0,$t0       # pseudo-instruction (macro)
    xor $v0,$t0,$t1
	nor $v0,$t0,$t1

	move $v0,$zero    # pseudo-instruction (macro)
	jr   $ra
	nop



.end main   #  directive that marks end of 'main' function 
            # and registers size in ELF output

