module sramtest(
  // Clock Input (50 MHz)
  input  CLOCK_50,
  //  Push Buttons
  input  [3:0]  KEY,
  //  DPDT Switches 
  input  [17:0]  SW,
  //  7-SEG Displays
  output  [6:0]  HEX0, HEX1, HEX2, HEX3, HEX4, HEX5, HEX6, HEX7,
  //  LEDs
  output  [8:0]  LEDG,  //  LED Green[8:0]
  output  [17:0]  LEDR,  //  LED Red[17:0]
  //  SRAM Interface
  inout  [15:0] SRAM_DQ,   // SRAM Data bus 16 Bits
  output [17:0] SRAM_ADDR, // SRAM Address bus 18 Bits
  output SRAM_UB_N,        // SRAM High-byte Data Mask
  output SRAM_LB_N,        // SRAM Low-byte Data Mask 
  output SRAM_WE_N,    // SRAM Write Enable
  output SRAM_CE_N,        // SRAM Chip Enable
  output SRAM_OE_N,        // SRAM Output Enable
  //  GPIO Connections
  inout  [35:0]  GPIO_0, GPIO_1
);

//  set all inout ports to tri-state
assign  GPIO_0    =  36'hzzzzzzzzz;
assign  GPIO_1    =  36'hzzzzzzzzz;

wire RST;
assign RST = KEY[0];

// Turn off green LEDS
assign LEDG[8:0] = 0;

// Connect dip switches to red LEDS
assign LEDR[17:0] = SW[17:0];

reg [15:0] mem_in;
wire [15:0] mem_out;
reg [17:0] mem_address;

assign SRAM_ADDR = mem_address;
assign SRAM_UB_N = 1'b0;        // SRAM High-byte Data Mask
assign SRAM_LB_N = 1'b0;        // SRAM Low-byte Data Mask 
assign SRAM_CE_N = 1'b0;        // SRAM Chip Enable
assign SRAM_OE_N = 1'b0;        // SRAM Output Enable
 

// map to 7-segment displays

hex_7seg dsp0(mem_out[3:0],HEX0);
hex_7seg dsp1(mem_out[7:4],HEX1);
hex_7seg dsp2(mem_out[11:8],HEX2);
hex_7seg dsp3(mem_out[15:12],HEX3);

hex_7seg dsp4(mem_address[3:0],HEX4);
hex_7seg dsp5(mem_address[7:4],HEX5);
hex_7seg dsp6(mem_address[11:8],HEX6);
hex_7seg dsp7(mem_address[15:12],HEX7);

always @(negedge KEY[3])
	mem_address <= SW;

reg state;
parameter idle = 1'b0, write = 1'b1;

assign SRAM_WE_N = (state != write);
assign SRAM_DQ = (state==write? mem_in: 16'hzzzz);

assign mem_out = SRAM_DQ;

always @(posedge CLOCK_50, negedge KEY[2])
if (!KEY[2]) 
  begin
     state <= write;
     mem_in <= SW[15:0];
  end
else state <= idle;
	   



endmodule