module diglab2(
  // Clock Input (50 MHz)
  input  CLOCK_50,
  //  Push Buttons
  input  [3:0]  KEY,
  //  DPDT Switches 
  input  [17:0]  SW,
  //  7-SEG Displays
  output  [6:0]  HEX0, HEX1, HEX2, HEX3, HEX4, HEX5, HEX6, HEX7,
  //  LEDs
  output  [8:0]  LEDG,  //  LED Green[8:0]
  output  [17:0]  LEDR,  //  LED Red[17:0]
  //  GPIO Connections
  inout  [35:0]  GPIO_0, GPIO_1
);

//  set all inout ports to tri-state
assign  GPIO_0    =  36'hzzzzzzzzz;
assign  GPIO_1    =  36'hzzzzzzzzz;

wire [6:0] myclock;
wire RST;
assign RST = KEY[0];

// Setup clock divider
clock_divider cdiv(CLOCK_50,RST,myclock);
assign GPIO_0[6:0] = myclock;

// Connect clock divider to green LEDs
assign LEDG[4:0] = myclock[4:0];

// Connect dip switches to red LEDS
assign LEDR[17:0] = SW[17:0];

// set up counters
wire [3:0] digit7, digit6;
wire ovr0, ovr1;

decimal_counter count0(digit6,ovr0,myclock[0],RST);
decimal_counter count1(digit7,ovr1,ovr0,RST);

// map to 7-segment displays

hex_7seg dsp0(digit6,HEX6);
hex_7seg dsp1(digit7,HEX7);

assign LEDG[7] = ovr1;
assign LEDG[6] = ovr0;

// turn unused LEDs off
assign LEDG[8] = 1'b0;
assign LEDG[5] = 1'b0;

// define a simple hex counter
reg [3:0] A;
always @ (posedge myclock[0])
   A <= A + 1'b1;

hex_7seg dsp2(A,HEX0); 

// blank remaining digits
assign HEX1 = 7'b111_1111;
assign HEX2 = 7'b111_1111;
assign HEX3 = 7'b111_1111;
assign HEX4 = 7'b111_1111;
assign HEX5 = 7'b111_1111;

endmodule