module rformat(input [5:0] fn, output [5:0] control);

// opcodes	
`include "opcodes.txt"

reg [3:0] acontrol;

always
	case (fn)
	NOR: acontrol = 4'b0111;
	AND: acontrol = 4'b0100;
	OR: acontrol = 4'b0101;
	XOR: acontrol = 4'b0110;
	ADD: acontrol = 4'b0000;
	ADDU: acontrol = 4'b0010;
	SUB: acontrol = 4'b0001;
	SUBU: acontrol = 4'b0011;
	SLT:  acontrol = 4'b1001;
	SLTU: acontrol = 4'b1011;
	default: acontrol = 4'b0000;
	endcase
	
assign control = {2'b00,acontrol};
	
endmodule
