module reg_file(clock,da,db,dc,ra,rb,rc,write_enable);
parameter BITS = 32;
input [BITS-1:0] dc;
output [BITS-1:0] da,db;
input [4:0] ra,rb,rc;
input clock, write_enable;
reg [BITS-1:0] r[0:31];

wire aflag = write_enable && (rc==ra) && ra;
wire bflag = write_enable && (rc==rb) && rb;

wire [BITS-1:0] qa,qb;

always @(posedge clock)
begin
	if (write_enable) r[rc] = dc;
end

assign	qa = ra? r[ra]: 0;
assign	qb = rb? r[rb]: 0;


// ensure read after write
assign da = aflag? dc: qa;
assign db = bflag? dc: qb;

endmodule			