module mrisclab1(
  // Clock Input (50 MHz)
  input  CLOCK_50,
  //  Push Buttons
  input  [3:0]  KEY,
  //  DPDT Switches 
  input  [17:0]  SW,
  //  7-SEG Displays
  output  [6:0]  HEX0, HEX1, HEX2, HEX3, HEX4, HEX5, HEX6, HEX7,
  //  LEDs
  output  [8:0]  LEDG,  //  LED Green[8:0]
  output  [17:0]  LEDR,  //  LED Red[17:0]
  // LCD Module
  output LCD_ON,   // LCD power on/off
  output LCD_BLON, // LCD back light on/off
  output LCD_RW,   // LCD Read/Write select, 0 = Write, 1 = Read
  output LCD_EN,   // LCD Enable
  output LCD_RS,   // LCD Command/Data Select, 0 = Command, 1 = Data
  inout [7:0] LCD_DATA, // LCD Data bus (8 bits)
  //  GPIO Connections
  inout  [35:0]  GPIO_0, GPIO_1
);

// turn LCD on
/*
assign LCD_ON = 1'b1;
assign LCD_BLON = 1'b1;
*/

//  set all inout ports to tri-state
assign  GPIO_0    =  36'hzzzzzzzzz;
assign  GPIO_1    =  36'hzzzzzzzzz;

wire [6:0] myclock;
wire reset_n = KEY[0];

// Setup clock divider
clock_divider cdiv(CLOCK_50,reset_n,myclock);
assign GPIO_0[6:0] = myclock;

// Connect clock divider to green LEDs
// LEDG[7:6] = cs
//assign LEDG[8:0] =  {7'd00,myclock[1:0]}; //{4'h00, myclock[4:0] };
assign LEDG[8:0] = {1'b0,clk,we,1'b0,active[4:0]};

// Connect dip switches to red LEDS
assign LEDR[17:0] = SW[17:0];

// map 7-segment displays

// blank unused digits
wire [6:0] blank = ~7'h00;
hex_7seg seg0(results[3:0],HEX0);
hex_7seg seg1(results[7:4],HEX1);
hex_7seg seg2(results[11:8],HEX2);
hex_7seg seg3(results[15:12],HEX3);
assign HEX4 = blank;
hex_7seg seg5(rd[3:0],HEX5);
//assign HEX5 = blank;
//assign HEX6 = blank;
//assign HEX7 = blank;
// program counter
hex_7seg seg6(pc[3:0],HEX6);
hex_7seg seg7(pc[7:4],HEX7);

// one-second clock
wire clk = myclock[0];

// memory bus
/*
wire [7:0] addr;
wire [15:0] q, data;
wire we;
*/

// i/o bus
/*
wire [1:0] io_addr;
wire [15:0] qio;
wire [2:0] cs;
wire io_we;

controller dev1(
	.clk(clk),
	// mem bus
	.addr(addr),
	.q(q),
	.data(data),
	.we(we),
	// i/o bus
	.io_addr(io_addr),
	.qio(qio),
	.cs(cs),
	.io_we(io_we)
);

switches u0(
	.clk(clk),
	.cs(cs[0]),
	.addr(io_addr),
	.data(qio),
	.we(io_we), 
	// DE2 end
	.sw(SW)
);



segments u1(
	.clk(clk),
	.cs(cs[1]),
	.addr(io_addr),
	.data(qio),
	.we(io_we),
	// DE2 end
	.HEX3(HEX3),
	.HEX2(HEX2),
	.HEX1(HEX1),
	.HEX0(HEX0)
);

LCD_controller u2(

	.clk(clk),
	.cs(cs[2]),
	.addr(io_addr),
	.data(qio),
	.we(io_we),
	// DE2 end
	.LCD_RS(LCD_RS), 
	.LCD_EN(LCD_EN), 
	.LCD_RW(LCD_RW),
	.DATA_BUS(LCD_DATA)
);
*/

wire [7:0] pc;
wire [31:0] ir, results;
wire [4:0] rd, active;
wire we;

mrisc1 cpu(
	.clock(clk), 
	.reset(reset_n),
	.pc(pc),
	.ir(ir), 
	.we(we), 
	.rd(rd), 
	.results(results),
	.active(active)
);

/*
dcpu2 cpu( 
	.clk(clk), 
	.reset_n(reset_n), 
	.loopback(1'b1),
	.pc(pc),
	// memory bus
	.addr(addr),
	.q(q),
	.data(data),
	.we(we)
);
*/


endmodule