module iformat(input [5:0] op,output [5:0] control, output reg [1:0] muxi);

// opcodes	
`include "opcodes.txt"

reg [3:0] acontrol;
reg [1:0] mem;
`define LW_C 1
`define SW_C 2

always
	case (op)
	ADDI: 
	begin
		acontrol <= 4'b0000; // add
		muxi <= 2'b01; // se 
	end
	ADDIU:
	begin
		acontrol <= 4'b0010; // addu
		muxi <= 2'b01; // se
	end
	ANDI: 
	begin
		acontrol <= 4'b0100; // andi
		muxi <= 2'b10;
	end
	ORI: 
	begin
		acontrol <= 4'b0101; // ori
		muxi <= 2'b10;
	end
	XORI: 
	begin 
		acontrol <= 4'b0110; // xor
		muxi <= 2'b10;
	end
	LUI: 
	begin
		acontrol <= 4'b0101; // or
		muxi <= 2'b11; // hi
	end
	SLTI:
	begin
		acontrol <= 4'b1001;
		muxi = 2'b01;
	end
	SLTIU:
	begin
		acontrol = 4'b1011;
		muxi = 2'b01;
	end
	LW:
	begin
		acontrol = 4'b0000;
		muxi = 2'b01;
	end
	SW:
	begin
		acontrol = 4'b0000;
		muxi = 2'b01;
	end
	default: 
	begin
		acontrol <= 4'b0000;
		muxi <= 2'b00; // nop
	end
	endcase

always
	case (op)
	LW: 
		mem <= `LW_C;
	SW:
		mem <= `SW_C;
	default:
		mem <= 2'b00;
	endcase
	
assign control = {mem,acontrol};	
	
endmodule
