/*
*     control
*      000  sll  shift left logical
*      001  srl  shift right logical
*      011  sra  shift right arithmetic
*      100  rol  rotate left
*      101  ror  rotate right
*/

module barrel6(
input [31:0] inp,
input [2:0] control,
input [4:0] shift,
output [31:0] out
);
wire [31:0] bit4,bit3,bit2,bit1;

// bit 4 (16)
stage s4(inp,bit4,control,shift[4]);
defparam s4.M = 4;

// bit 3 (8)
stage s3(bit4,bit3,control,shift[3]);
defparam s3.M = 3;

// bit 2 (4)
stage s2(bit3,bit2,control,shift[2]);
defparam s2.M = 2;

// bit 1 (2)
stage s1(bit2,bit1,control,shift[1]);
defparam s1.M = 1;

// bit 0 (1)
stage s0(bit1,out,control,shift[0]);
defparam s0.M = 0;

endmodule

module stage(
input [31:0] inp,
output reg [31:0] out,
input [2:0] control,
input shift
);

localparam
  sll = 3'b000,
	srl = 3'b001,
	sra = 3'b011,
	rol = 3'b100,
	ror = 3'b101;

parameter M = 4;
parameter N = 2**M;
always @(*)
	if (shift)
	case (control)
	sll: out <= {inp[31-N:0],{(N){1'b0}}};
	srl: out <= {{(N){1'b0}},inp[31:N]};
	sra: out <= {(inp[31]? {(N){1'b1}}: {(N){1'b0}}),inp[31:N]};
	rol: out <= {inp[31-N:0],inp[31:32-N]};
	ror: out <= {inp[N-1:0],inp[31:N]};
	default: out<= inp;
	endcase
	else out <= inp;
endmodule