module mux_test;
reg a, b, s;
wire f1,f2,f3,test;

mux1 g1(a,b,s,f1);
mux2 g2(a,b,s,f2);
mux3 g3(a,b,s,f3);
assign test = (f1==f2) & (f1==f3);

initial
begin
	b = 1'b0; a = 1'b0; s = 1'b0;
#10
	b = 1'b0; a = 1'b1; 
#10
	b = 1'b1; a = 1'b0;
#10
	b = 1'b1; a = 1'b1;
#10
	b = 1'b0; a = 1'b0; s = 1'b1;
#10
	b = 1'b0; a = 1'b1; 
#10
	b = 1'b1; a = 1'b0;
#10
	b = 1'b1; a = 1'b1;
#10
	b = 1'b0; a = 1'b0;
end
initial
	$monitor("time %4d s %b b %b a %b f %b test %s",
		$time,s,b,a,f1,test? "valid":"invalid");
endmodule