// behavioral version
/*
*     control
*     00  no operation
*     01  logical shift left
*     10  logical shift right
*     11  arithmetic shift right
*/

module barrel1(in,out,shamt,control);
input [31:0] in;
output [31:0] out;
input [4:0] shamt;
input [1:0] control;

reg [31:0] out;

// we want se<<(32-shamt)
// but se<<32 = se and -shamt = ~shamt + 1 (two's complement)
// can do (se<<1) by setting lsb to zero:
wire [31:0] se;
assign se = {{31{in[31]}},1'b0};

always
case (control)
2'b00: 
	out <= in;
2'b01:
	out <= (in<<shamt);
2'b10:
	out <= (in>>shamt);
2'b11:
	out <= (in>>shamt)| (se<<~shamt);
	//out <= (in>>>shamt);
default:
	out <= in;
endcase

endmodule