//#define DBUG
#if defined(DBUG)
	#include "sys/alt_stdio.h"
	#define DBPRINTF alt_printf
#else
    #define DBPRINTF
#endif

int main()
{
	unsigned int na, ns, nv;
	na = 0x8000F731;
	DBPRINTF("na = 0x%x\n",na);

	// logical shift left
	nv = na<<3;
	DBPRINTF("na<<3 = 0x%x\n",nv);
	// logical shift right
	nv = na>>3;
	DBPRINTF("na>>3 = 0x%x\n",nv);
	// arithmetic shift right
	nv = ((signed)na)>>3;
	DBPRINTF("((signed)na)>>3 = 0x%x\n",nv);

	// rotate right
	nv = (na>>4)|(na<<28);
	DBPRINTF("rot right 4 = 0x%x\n",nv);

	// rotate left
	nv = (na<<4)|(na>>28);
	DBPRINTF("rot left 4 = 0x%x\n",nv);

	// use variable as shift amount
	ns = 5;
	DBPRINTF("Use variable as shift amount\n ns = %d\n",ns);

	nv = na>>ns;
	DBPRINTF("na>>ns = 0x%x\n",nv);

	nv = na<<ns;
	DBPRINTF("na<<ns = 0x%x\n",nv);

	ns = 8;
	// rotate right
	nv = (na>>ns)|(na<<(32-ns));
	DBPRINTF("rot right 8 = 0x%x\n",nv);

	// rotate left
	nv = (na<<ns)|(na>>(32-ns));
	DBPRINTF("rot left 8 = 0x%x\n",nv);

	/* Event loop never exits. */
	while (1);
	return 0;
}
