function out = filters2(M)


if (nargin<1)
    M=7;
end
rg = (M-1)/2;

%% a0, a1, a2
x = ones(M,1)*(-rg:rg);
y = x'; % flipud to get cartesian y
rsq = x.^2+y.^2;
rsqe = (M/2)^2;
h0 = im2double(rsq<rsqe);
h1 = x.*h0;
h2 = y.*h0;



%% b11, b22, and b12

h11 = h1.*h1.*h0;
n1 = sum(sum(h11));
n2 = sum(sum(h0));
h11 = h11-h0*n1/n2;
h22 = h11';
h12 = h1.*h2;

%%

out(:,:,1) = h0;
out(:,:,2) = h1;
out(:,:,3) = h2;
out(:,:,4) = h11;
out(:,:,5) = h22;
out(:,:,6) = h12;
