%% color_test


%%

clear
close all
load filelist
warning('off','images:initSize:adjustingMag');


%%

m = 2;
%m = 41;
rgb = imread(files(m,:));
%rgb = imread('crop.jpg');
imshow(rgb);
%[msg msgid] = lastwarn

%%

small_area = 500;
rgbd = im2double(rgb);
g = rgb2gray(rgbd);
imshow(g);

%%

imhist(g);


%%

cdiff = max(rgbd,[], 3) - min(rgbd, [], 3);
mask = cdiff<0.15;
imshow(mask);

%%

black = g<0.3;
imshow(black&mask);

%%

white = g>0.7;
imshow(white&mask);

%%

se1 = strel('square',7);
b1 = imdilate(black,se1);
w1 = imdilate(white,se1);
bw1 = w1&b1;
bw2 = bwareaopen(bw1,500);

imshow(bw2);

%%

CC = bwconncomp(bw2);
disp(CC);
L = labelmatrix(CC);
imshow(label2rgb(L));

%%

s = regionprops(CC,'Image','FilledImage','Area','EulerNumber','BoundingBox');
euler = [s.EulerNumber]';
idx = find(abs(euler)>20);

M = length(idx);
for k=1:M
    subplot(1,M,k);
    imshow(s(idx(k)).Image);
end

%%

s(idx)
bb = s(idx).BoundingBox;
img = imcrop(rgb,floor(bb));
subplot(1,2,1);
imshow(img);
subplot(1,2,2);
imshow(s(idx).Image);


%%

close all;
sz = size(s(idx).Image);
small_area = ceil(.003*(sz(1)*sz(2)));
fprintf('small_area %g\n',small_area);
bw3 = s(idx).FilledImage&~s(idx).Image;
bw4 = bwareaopen(bw3,small_area);
CC2 = bwconncomp(bw4);
L2 = labelmatrix(CC2);
subplot(2,2,1);
imshow(img);
subplot(2,2,2);
rgbm = label2rgb(L2,'jet','k');
imshow(rgbm);
subplot(2,2,3);
mask = sum(rgbm,3)==0;
imshow(mask);
subplot(2,2,4);
gc = imcrop(g,bb);
if (size(gc)~=size(mask))
    diff = size(gc)-size(mask);
    rect = bb - [0 0 diff(2) diff(1)];
    gc = imcrop(g,rect);
end
gm = gc.*mask;
rgbn = cat(3,gm,gm,gm)+im2double(rgbm);
imshow(rgbn);
%imshow(label2rgb(L2));

%%

s2 = regionprops(CC2,'Area','Eccentricity','Centroid');

area = cat(1,s2.Area);
maxarea = max(area);
fprintf('maximum area %g\n',maxarea);
kdx = find(area>0.5*maxarea);
fprintf('number of squares %d\n',length(area));
fprintf('number of fullsize squares %d\n',length(kdx));
fprintf('Euler %d\n',-s(idx).EulerNumber);

%%


close all
area = [s2.Area]'/maxarea;
ecen = [s2.Eccentricity]';
[ecen_sorted ndx] = sort(ecen);
plot(area,ecen,'ko');
axis([0 1 0 1]);
grid;
xlabel('relative area');
ylabel('eccentricity');

%disp('      area      ecen');
%disp([area(ndx) ecen(ndx)])


%%

ndx = find(ecen<0.6);

pts = reshape([s2.Centroid],2,length(s2));
imshow(label2rgb(L2));
hold on
plot(pts(1,ndx),pts(2,ndx),'ko','LineWidth',2,'MarkerSize',6,'MarkerFaceColor','white');
hold off

%%

close all
rgbm = label2rgb(L,'jet','k');
mask = sum(rgbm,3)==0;
gm = g.*mask;
rgbn = cat(3,gm,gm,gm)+im2double(rgbm);
imshow(rgbn);







